<?php
// Funkcja obcinajca tekst do okrelonej dugoci, wywietlajca informacj, e jest dostpny cig dalszy.
function truncate_text_nicely($string, $max, $moretext) {
    // Przetwarzanie cigu tylko wtedy, gdy jest duszy ni $max znakw.
    if (strlen($string) > $max) {
        // Modyfikacja zmiennej $max poprzez odjcie dugoci zmiennej $moretext.
        $max -= strlen($moretext);
    
        // Pobranie tylko waciwej czci cigu:
        $string = strrev(strstr(strrev(substr($string, 0, $max)), ' '));
    
        // Dodanie do niego tekstu $moretext:
        $string .= $moretext;
    }

    // Zwrcenie cigu znakw, niezalenie od tego, czy go zmodyfikowano, czy nie.
    return $string;
}

$str = 'Bya ciemna noc i szalaa burza, kiedy baron przygotowa swj samolot.';

// Rozbicie cigu na czci:
$values = truncate_text_nicely($str, 36, '...');

// Prba wywietlenia wyniku zwrci nastpujcy tekst:  Bya ciemna noc i szalaa burza ...
echo "<pre>{$values}</pre>";
?>

